unit fMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, IniFiles, ExtCtrls, Math;

type
  TMacrosRec = record
    Key: Word;
    ssShift: boolean;
    ssAlt: boolean;
    ssCtrl: boolean;
    delay: real;
  end;

  TMacros = record
    Name: String;
    Data: array of TMacrosRec;
  end;

  TfrmMain = class(TForm)
    Label1: TLabel;
    obConnectToClient: TButton;
    lbConnectStatus: TLabel;
    Timer: TTimer;
    eClientCaption: TComboBox;
    cbAlwaysTop: TCheckBox;
    Panel1: TPanel;
    cbUse: TCheckBox;
    gMacrosName: TStringGrid;
    gMacrosData: TStringGrid;
    obRename: TButton;
    obUSe: TButton;
    cbSendkeyup: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure obConnectToClientClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure cbAlwaysTopClick(Sender: TObject);
    procedure obRenameClick(Sender: TObject);
    procedure cbUseClick(Sender: TObject);
    procedure obUSeClick(Sender: TObject);
    procedure gMacrosNameClick(Sender: TObject);
  private
    { Private declarations }
  public
    SelectedMacros: Integer;
    CurentMacrosRec: Integer;
    Macros: array of TMacros;
    NextTimeUse: DWORD;

    function  ConnectToClient: boolean;
    function  ConnectedToClient: boolean;
    procedure DisconnectFromClient;

    procedure ClearMacros;
    procedure ClearGrids;
    procedure GridToMacros;
    procedure MacrosToGrid;
    procedure SaveMacros;
    procedure LoadMacros;
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses StrUtils;

{$R *.dfm}

var
  hWindow, hProcess : THandle;
  pidWindow, pid    : DWORD;
  SendingKey        : Boolean = False;

function FileVersion(AFileName: string): string;
var
  szName: array[0..255] of Char;
  P: Pointer;
  Value: Pointer;
  Len: UINT;
  GetTranslationString: string;
  FFileName: PChar;
  FValid: boolean;
  FSize: DWORD;
  FHandle: DWORD;
  FBuffer: PChar;
begin
  try
    FFileName := StrPCopy(StrAlloc(Length(AFileName) + 1), AFileName);
    FValid := False;
    FSize := GetFileVersionInfoSize(FFileName, FHandle);
    if FSize > 0 then
    try
      GetMem(FBuffer, FSize);
      FValid := GetFileVersionInfo(FFileName, FHandle, FSize, FBuffer);
    except
      FValid := False;
      raise;
    end;
    Result := '';
    if FValid then
      VerQueryValue(FBuffer, '\VarFileInfo\Translation', p, Len)
    else
      p := nil;
    if P <> nil then
      GetTranslationString := IntToHex(MakeLong(HiWord(Longint(P^)),
        LoWord(Longint(P^))), 8);
    if FValid then
    begin
      StrPCopy(szName, '\StringFileInfo\' + GetTranslationString +
        '\FileVersion');
      if VerQueryValue(FBuffer, szName, Value, Len) then
        Result := StrPas(PChar(Value));
    end;
  finally
    try
      if FBuffer <> nil then
        FreeMem(FBuffer, FSize);
    except
    end;
    try
      StrDispose(FFileName);
    except
    end;
  end;
end;

function StrToKey(Key: String): WORD;
begin
  Key := AnsiUpperCase(Key);
  if Key = 'F1' then
    Result := VK_F1
  else
  if Key = 'F2' then
    Result := VK_F2
  else
  if Key = 'F3' then
    Result := VK_F3
  else
  if Key = 'F4' then
    Result := VK_F4
  else
  if Key = 'F5' then
    Result := VK_F5
  else
  if Key = 'F6' then
    Result := VK_F6
  else
  if Key = 'F7' then
    Result := VK_F7
  else
  if Key = 'F8' then
    Result := VK_F8
  else
  if Key = 'F9' then
    Result := VK_F9
  else
  if Key = 'F10' then
    Result := VK_F10
  else
  if Key = 'F11' then
    Result := VK_F11
  else
  if Key = 'F12' then
    Result := VK_F12
  else
  if (Key = 'TAB') then
    Result := VK_TAB
  else
  if length(Key) = 1 then
    Result := ord(Key[1])
  else
  if length(Key) > 1 then
    Result := StrToIntDef('$'+Key, 0)
  else
    Result := 0;
end;

function KeyToStr(Code: WORD): String;
begin
  if (Code >= VK_F1) and (Code <= VK_F12) then
    Result := 'F'+IntToStr(Code-VK_F1+1)
  else
  if Code = VK_TAB then
    Result := 'TAB'
  else
  if (Code > $20) and (Code <= $FF) then
    Result := chr(Code)
  else
    Result := IntToHex(Code, 4);
end;

{************************************************************
 * Parameters:
 *  hWindow: target window to be send the keystroke
 *  key    : virtual keycode of the key to send. For printable
 *           keys this is simply the ANSI code (Ord(character)).
 *  shift  : state of the modifier keys. This is a set, so you
 *           can set several of these keys (shift, control, alt,
 *           mouse buttons) in tandem. The TShiftState type is
 *           declared in the Classes Unit.
 *  specialkey: normally this should be False. Set it to True to
 *           specify a key on the numeric keypad, for example.
 *           If this parameter is true, bit 24 of the lparam for
 *           the posted WM_KEY* messages will be set.
 * Description:
 *  This procedure sets up Windows key state array to correctly
 *  reflect the requested pattern of modifier keys and then posts
 *  a WM_KEYDOWN/WM_KEYUP message pair to the target window. Then
 *  Application.ProcessMessages is called to process the messages
 *  before the keyboard state is restored.
 * Error Conditions:
 *  May fail due to lack of memory for the two key state buffers.
 *  Will raise an exception in this case.
 * NOTE:
 *  Setting the keyboard state will not work across applications
 *  running in different memory spaces on Win32 unless AttachThreadInput
 *  is used to connect to the target thread first.
 *Created: 02/21/96 16:39:00 by P. Below
 ************************************************************}

procedure SendKey(key: Word; const shift: TShiftState; sendkeyup: boolean; specialkey: Boolean);
type
  TBuffers = array [0..1] of TKeyboardState;
var
  pKeyBuffers: ^TBuffers;
  lParam: LongInt;
begin
   (* check if the target window exists *)
   if hWindow <> 0 then
   begin
     SendingKey := True;
     (* set local variables to default values *)
     lParam := MakeLong(0, MapVirtualKey(key, 0));

     (* modify lparam if special key requested *)
     if specialkey then
       lParam := lParam or $1000000;

     (* allocate space for the key state buffers *)
     New(pKeyBuffers);
     try
       (* Fill buffer 1 with current state so we can later restore it.
          Null out buffer 0 to get a "no key pressed" state. *)
       GetKeyboardState(pKeyBuffers^[1]);
       FillChar(pKeyBuffers^[0], SizeOf(TKeyboardState), 0);

       (* set the requested modifier keys to "down" state in the buffer*)
       if ssShift in shift then
         pKeyBuffers^[0][VK_SHIFT] := $80;
       if ssAlt in shift then
       begin
         (* Alt needs special treatment since a bit in lparam needs also be set *)
         pKeyBuffers^[0][VK_MENU] := $80;
         lParam := lParam or $20000000;
       end;
       if ssCtrl in shift then
         pKeyBuffers^[0][VK_CONTROL] := $80;
       if ssLeft in shift then
         pKeyBuffers^[0][VK_LBUTTON] := $80;
       if ssRight in shift then
         pKeyBuffers^[0][VK_RBUTTON] := $80;
       if ssMiddle in shift then
         pKeyBuffers^[0][VK_MBUTTON] := $80;

       (* make out new key state array the active key state map *)
       SetKeyboardState(pKeyBuffers^[0]);
       (* post the key messages *)
       if ssAlt in Shift then
       begin
         PostMessage(hWindow, WM_SYSKEYDOWN, integer(key), integer(lParam));
         if sendkeyup then
           PostMessage(hWindow, WM_SYSKEYUP, integer(key), integer(lParam or $C0000000));
       end
       else
       begin
         PostMessage(hWindow, WM_KEYDOWN, integer(key), integer(lParam));
         if sendkeyup then
           PostMessage(hWindow, WM_KEYUP, integer(key), integer(lParam or $C0000000));
       end;
       (* process the messages *)
       Application.ProcessMessages;

       (* restore the old key state map *)
       SetKeyboardState(pKeyBuffers^[1]);
     finally
       (* free the memory for the key state buffers *)
       if pKeyBuffers <> nil then
         Dispose(pKeyBuffers);
     end; { If }
     SendingKey := False;
   end;
 end;

procedure TfrmMain.FormCreate(Sender: TObject);
var
  ini: TIniFile;
begin
  Caption := Caption + ' ' + FileVersion(Application.ExeName);

  hProcess  := 0;

  ini := TIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));
  Ini.ReadSection('Perfect World Captions', eClientCaption.Items);
  cbAlwaysTop.Checked := ini.ReadBool('Common', 'AlwaysTop', True);
  ini.Free;
  if cbAlwaysTop.Checked then
    FormStyle := fsStayOnTop
  else
    FormStyle := fsNormal;

  gMacrosName.Cells[0, 0] := '';

  gMacrosData.Cells[0, 0] := '';
  gMacrosData.Cells[1, 0] := 'CTRL';
  gMacrosData.Cells[2, 0] := 'ALT';
  gMacrosData.Cells[3, 0] := 'SHIFT';
  gMacrosData.Cells[4, 0] := '';

  SelectedMacros := 0;
  CurentMacrosRec := 0;
  NextTimeUse := 0;

  SetLength(Macros, gMacrosData.RowCount-1);

  LoadMacros;
  MacrosToGrid;
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
var
  i: integer;
  Ini: TIniFile;
begin
  DisconnectFromClient;

  ini := TIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));

  try
    for I := 0 to eClientCaption.Items.Count-1 do
      Ini.WriteString('Perfect World Captions', eClientCaption.Items[i], '');
  except
  end;

  ini.WriteBool('Common', 'AlwaysTop', cbAlwaysTop.Checked);

  ini.Free;

  SaveMacros;
  ClearMacros;
end;

procedure TfrmMain.gMacrosNameClick(Sender: TObject);
begin
  SelectedMacros := gMacrosName.Row-1;
  CurentMacrosRec := 0;
  MacrosToGrid;
end;

function TfrmMain.ConnectToClient: boolean;
begin
  Result := False;
  try
    DisconnectFromClient;
    hWindow := FindWindow(nil, pChar(eClientCaption.text));
    if hWindow <> 0 then
    begin
      pidWindow := GetWindowThreadProcessId(hWindow, PID);
      if pidWindow <> 0 then
      begin
        hProcess  := OpenProcess(PROCESS_ALL_ACCESS, False, PID);
        Result := hProcess  <> 0;
      end;
    end;
  except
  end;
end;

procedure TfrmMain.DisconnectFromClient;
begin
  if ConnectedToClient then
    CloseHandle(hProcess);
  hProcess  := 0;
end;

function TfrmMain.ConnectedToClient: boolean;
begin
  Result := hProcess  <> 0;
end;

procedure TfrmMain.obConnectToClientClick(Sender: TObject);
begin
  //    
  if lbConnectStatus.Caption <> ' ' then
  begin
    lbConnectStatus.Color := clRed;
    if ConnectToClient then
      lbConnectStatus.Caption := ' '
    else
      lbConnectStatus.Caption := ' ';
    lbConnectStatus.Update;
    Sleep(500);
    lbConnectStatus.Color := clBtnFace;
    lbConnectStatus.Update;
    if ConnectedToClient then
    begin
      if eClientCaption.Items.IndexOf(eClientCaption.Text) < 0 then
        eClientCaption.Items.Add(eClientCaption.Text);
      obConnectToClient.Caption := '';
    end;
  end
  else
  begin
    DisconnectFromClient;
    obConnectToClient.Caption := '';
    lbConnectStatus.Caption := ' ';
  end;
end;

procedure TfrmMain.TimerTimer(Sender: TObject);
var
  Shift: TShiftState;
begin
  if ConnectedToClient and not SendingKey then
  begin
    if (SelectedMacros < 0) or (SelectedMacros >= length(Macros)) then
      SelectedMacros := 0;
    if (SelectedMacros >= 0) and (SelectedMacros < length(Macros)) then
    begin
      if (CurentMacrosRec < 0) or (CurentMacrosRec >= length(Macros[SelectedMacros].Data)) then
        CurentMacrosRec := 0;
      if (CurentMacrosRec >= 0) and (CurentMacrosRec < length(Macros[SelectedMacros].Data)) {and (GetTickCount >= NextTimeUse)} then
      begin
        Shift := [];
        with Macros[SelectedMacros].Data[CurentMacrosRec] do
        begin
          if ssCtrl then
            Shift := Shift + [classes.ssCtrl];
          if ssAlt then
            Shift := Shift + [classes.ssAlt];
          if ssShift then
            Shift := Shift + [classes.ssShift];
          SendKey(Key, Shift, cbSendkeyup.Checked, False);
        end;
        if GetTickCount >= NextTimeUse then
        begin
          inc(CurentMacrosRec);
          if (CurentMacrosRec < 0) or (CurentMacrosRec >= length(Macros[SelectedMacros].Data)) then
            CurentMacrosRec := 0;
          if (CurentMacrosRec >= 0) and (CurentMacrosRec < length(Macros[SelectedMacros].Data)) then
            NextTimeUse := GetTickCount + round(Macros[SelectedMacros].Data[CurentMacrosRec].delay*1000);
        end;
      end;
    end;
  end;
end;

procedure TfrmMain.cbAlwaysTopClick(Sender: TObject);
begin
  if cbAlwaysTop.Checked then
    FormStyle := fsStayOnTop
  else
    FormStyle := fsNormal;
end;

procedure TfrmMain.obRenameClick(Sender: TObject);
var
  St: String;
begin
  if ConnectedToClient then
  begin
    St := eClientCaption.Text;
    SetWindowText(hWindow, PChar(St));
    eClientCaption.Text := St;
    if eClientCaption.Items.IndexOf(eClientCaption.Text) < 0 then
      eClientCaption.Items.Add(eClientCaption.Text);
  end;
end;

procedure TfrmMain.cbUseClick(Sender: TObject);
begin
  if cbUse.Checked then
  begin
    CurentMacrosRec := 0;
    NextTimeUse := 0;
  end;
  Timer.Enabled := cbUse.Checked;
end;

procedure TfrmMain.obUSeClick(Sender: TObject);
begin
  GridToMacros;
  CurentMacrosRec := 0;
  NextTimeUse := 0;
  SaveMacros;
end;

procedure TfrmMain.GridToMacros;
var
  mi, i, len: integer;
begin
  for mi := 1 to gMacrosName.RowCount-1 do
  begin
    Macros[mi-1].Name := trim(gMacrosName.Cells[0, mi]);
    if mi-1 = SelectedMacros then
    begin
      len := 0;
      for I := 1 to gMacrosData.RowCount-1 do
        if trim(gMacrosData.Cells[0, i]) <> '' then
        begin
          SetLength(Macros[mi-1].Data, len + 1);
          Macros[mi-1].Data[len].Key := StrToKey(gMacrosData.Cells[0, i]);
          Macros[mi-1].Data[len].ssCtrl := trim(gMacrosData.Cells[1, i]) <> '';
          Macros[mi-1].Data[len].ssAlt := trim(gMacrosData.Cells[2, i]) <> '';
          Macros[mi-1].Data[len].ssShift := trim(gMacrosData.Cells[3, i]) <> '';
          Macros[mi-1].Data[len].delay := StrToFloatDef(gMacrosData.Cells[4, i], 0);
          inc(len);
        end;
    end;
  end;
end;

procedure TfrmMain.MacrosToGrid;
var
  mi, i, mlen, len: integer;
begin
  ClearGrids;
  mlen := length(Macros);
  for mi := 0 to mlen-1 do
    gMacrosName.Cells[0, mi+1] := Macros[mi].Name;

  if (SelectedMacros >= 0) and (SelectedMacros < mlen) then
  begin
    len := length(Macros[SelectedMacros].Data);
    for I := 0 to len-1 do
      begin
        gMacrosData.Cells[0, i+1] := KeyToStr(Macros[SelectedMacros].Data[i].Key);
        gMacrosData.Cells[1, i+1] := IfThen(Macros[SelectedMacros].Data[i].ssCtrl, '1', '');
        gMacrosData.Cells[2, i+1] := IfThen(Macros[SelectedMacros].Data[i].ssAlt, '1', '');
        gMacrosData.Cells[3, i+1] := IfThen(Macros[SelectedMacros].Data[i].ssShift, '1', '');
        gMacrosData.Cells[4, i+1] := FloatToStr(Macros[SelectedMacros].Data[i].delay);
      end;
  end;
end;

procedure TfrmMain.ClearMacros;
var
  i, len: integer;
begin
  len := length(Macros);
  for i := 0 to len-1 do
  begin
    Macros[i].Name := '';
    SetLength(Macros[i].Data, 0);
  end;
  SetLength(Macros, 0);
end;

procedure TfrmMain.ClearGrids;
var
  c, r: integer;
begin
  for r := 1 to gMacrosName.RowCount-1 do
    gMacrosName.Cells[0, r] := '';
  for r := 1 to gMacrosData.RowCount-1 do
    for c := 0 to gMacrosData.ColCount-1 do
      gMacrosData.Cells[c, r] := '';
end;

procedure TfrmMain.SaveMacros;
var
  mi, i, mlen, len: integer;
  ini: TIniFile;
begin
  if FileExists(ExtractFilePath(Application.ExeName)+'macros.ini') then
    DeleteFile(ExtractFilePath(Application.ExeName)+'macros.ini');
  ini := TIniFile.Create(ExtractFilePath(Application.ExeName)+'macros.ini');
  mlen := length(Macros);
  for mi := 0 to mlen-1 do
  begin
    len := length(Macros[mi].Data);
    for I := 0 to len-1 do
    begin
      ini.WriteString(Macros[mi].Name, IntToStr(I),
        KeyToStr(Macros[mi].Data[i].Key)+' '+
        IfThen(Macros[mi].Data[i].ssCtrl, '1', '0')+' '+
        IfThen(Macros[mi].Data[i].ssAlt, '1', '0')+' '+
        IfThen(Macros[mi].Data[i].ssShift, '1', '0')+' '+
        FloatToStr(Macros[mi].Data[i].delay));
    end;
  end;
  ini.Free;
end;

procedure TfrmMain.LoadMacros;
var
  St, Item: String;
  mi, i, pos, mlen, len: integer;
  ini: TMemIniFile;
  lMacros, lMacrosData: TStringList;
begin
  lMacros := TStringList.Create;
  ini := TMemIniFile.Create(ExtractFilePath(Application.ExeName)+'macros.ini');
  ini.ReadSections(lMacros);
  mlen := lMacros.Count;
  for mi := 0 to mlen-1 do
  begin
    Macros[mi].Name := lMacros[mi];
    lMacrosData := TStringList.Create;
    ini.ReadSection(Macros[mi].Name, lMacrosData);
    len := lMacrosData.Count;
    SetLength(Macros[mi].Data, len);
    for I := 0 to len-1 do
    begin
      St := ini.ReadString(Macros[mi].Name, lMacrosData[i], '');
      pos := 1;

      Item := '';
      while (pos <= length(St)) and (St[pos] = ' ') do
        inc(pos);
      while (pos <= length(St)) and (St[pos] <> ' ') do
      begin
        Item := Item + St[pos];
        inc(pos);
      end;
      Macros[mi].Data[i].Key := StrToKey(Item);

      Item := '';
      while (pos <= length(St)) and (St[pos] = ' ') do
        inc(pos);
      while (pos <= length(St)) and (St[pos] <> ' ') do
      begin
        Item := Item + St[pos];
        inc(pos);
      end;
      Macros[mi].Data[i].ssCtrl := Item <> '0';

      Item := '';
      while (pos <= length(St)) and (St[pos] = ' ') do
        inc(pos);
      while (pos <= length(St)) and (St[pos] <> ' ') do
      begin
        Item := Item + St[pos];
        inc(pos);
      end;
      Macros[mi].Data[i].ssAlt := Item <> '0';

      Item := '';
      while (pos <= length(St)) and (St[pos] = ' ') do
        inc(pos);
      while (pos <= length(St)) and (St[pos] <> ' ') do
      begin
        Item := Item + St[pos];
        inc(pos);
      end;
      Macros[mi].Data[i].ssShift := Item <> '0';

      Item := '';
      while (pos <= length(St)) and (St[pos] = ' ') do
        inc(pos);
      while (pos <= length(St)) and (St[pos] <> ' ') do
      begin
        Item := Item + St[pos];
        inc(pos);
      end;
      Macros[mi].Data[i].delay := StrtoFloatDef(Item, 0);
    end;
    lMacrosData.Free;
  end;
  ini.Free;
  lMacros.Free;
end;

end.
