unit uMemory;

interface

uses
  Windows, SysUtils;

type
  PParams = ^TParams;
  TParams = packed record
    Packet: array [0..100] of byte;
    Param1,Param2,Param3: DWord;
    Param4: array [1..100] of widechar;
  end;

var
  hProcess: DWORD = 0;

  procedure InjectFunc(ProcessID: Cardinal; Func, aParams: Pointer; aParamsSize: DWord);
  function dwValueToString(Value: DWORD): String;
  procedure Packet(BaseAddr: dword; PacketAddr: dword; Packet: string);
  function ChainReadInt32(addresses: array of DWORD): DWORD;
  procedure ChainWriteInt32(addresses: array of DWORD; Value: DWORD);
  function ChainReadString(addr: DWORD; MaxCharCount: integer): string;
  function ReadInt32(addr: DWORD): DWORD;
  procedure WriteInt32(addr: DWORD; Value: DWORD);
  function Walk(base_addr, game_addr, WalkMode, walkx_inject_addr, walky_inject_addr, walkz_inject_addr: dword;
    x,y,z: single): Boolean;

implementation

procedure PacketCall(aPParams:PParams); stdcall;
var
  CallAddress,pPacket:pointer;
  BaseAddresses: DWord;
  PacketAddr: DWord;
  Len:DWord;
begin
  PacketAddr := aPParams^.Param3;
  CallAddress:=Pointer(PacketAddr);
  BaseAddresses:=aPParams^.Param2;
  Len:=aPParams^.Param1;
  pPacket:=@aPParams^.Packet;
  asm
    pushad
    mov ecx, BaseAddresses
    mov ecx, dword ptr [ecx]
    mov ecx, dword ptr [ecx+$20]
    push Len
    push pPacket
    call CallAddress
    popad
  end;
end;

procedure StrToByte(Packet:string; var aParams:TParams);
var
  i, cnt: integer;
begin
  cnt:=((length(Packet)+1) div 3);
  aParams.Param1 := cnt;
  for i:=0 to cnt-1 do
    aParams.Packet[i]:=strtoint('$'+Packet[i*3+1]+Packet[i*3+2]);
end;


procedure InjectFunc(ProcessID: Cardinal; Func, aParams: Pointer; aParamsSize: DWord);
var
  hThread: THandle;
  lpNumberOfBytes: DWord;
  ThreadAddr, ParamAddr: Pointer;
begin
  if ProcessID <> 0 then
  begin
    // ----     ,     
    ThreadAddr := VirtualAllocEx(ProcessID, nil, 256, MEM_COMMIT, PAGE_READWRITE);
    WriteProcessMemory(ProcessID, ThreadAddr, Func, 256, lpNumberOfBytes);

    // ----     
    ParamAddr := VirtualAllocEx(ProcessID, nil, aParamsSize, MEM_COMMIT, PAGE_READWRITE);
    WriteProcessMemory(ProcessID, ParamAddr, aParams, aParamsSize, lpNumberOfBytes);

    // ----  ,      .
    hThread := CreateRemoteThread(ProcessID, nil, 0, ThreadAddr, ParamAddr, 0, lpNumberOfBytes);

    // ----   
    WaitForSingleObject(hThread, INFINITE);

    // ----   
    CloseHandle(hThread);
    VirtualFreeEx(ProcessID, ParamAddr, 0, MEM_RELEASE);
    VirtualFreeEx(ProcessID, ThreadAddr, 0, MEM_RELEASE);
  end
end;

procedure Packet(BaseAddr: dword; PacketAddr: dword; Packet: string);
var
  aParams: TParams;
begin
  StrToByte(Packet,aParams);
  aParams.Param2 := BaseAddr;
  aParams.Param3 := PacketAddr;
  InjectFunc(hProcess, @PacketCall, @aParams,sizeof(aParams));
end;

function ChainReadInt32(addresses: array of DWORD): DWORD;
var
  BytesCountOfRead: DWORD;
  i, len: Integer;
  addr: DWORD;
begin
  len := length(addresses);
  addr := 0;
  try
    for i:=0 to len-1 do
      if (addr+addresses[i]+4 < $FFFFFFFF) then
        ReadProcessMemory(hProcess, ptr(addr+addresses[i]), @addr, 4, BytesCountOfRead)
      else
      begin
        addr := 0;
        break;
      end;
    Result := addr;
  except
    Result := 0;
  end;
end;

procedure ChainWriteInt32(addresses: array of DWORD; Value: DWORD);
var
  BytesCountOfRead: DWORD;
  BytesCountOfWrite: DWORD;
  i, len: Integer;
  addr: DWORD;
begin
  len := length(addresses);
  if len > 0 then
  begin
    addr := 0;
    try
      for i:=0 to len-2 do
        if (addr+addresses[i]+4 < $FFFFFFFF) then
          ReadProcessMemory(hProcess, ptr(addr+addresses[i]), @addr, 4, BytesCountOfRead)
        else
        begin
          addr := 0;
          break;
        end;
      if (addr > 0) and (addr+addresses[len-1]+4 < $FFFFFFFF) then
        WriteProcessMemory(hProcess, ptr(addr+addresses[len-1]), @Value, 4, BytesCountOfWrite);
    except
    end;
  end;
end;

function ChainReadString(addr: DWORD; MaxCharCount: integer): string;
var
  BytesCountOfRead, Size: DWORD;
  sValue: array [0..255] of WideChar;
begin
  result := '';
  if (MaxCharCount > 0) and (addr+4 < $FFFFFFFF) then
  try
    Size := SizeOf(sValue);
    if Size > (MaxCharCount * 2) then
      Size := MaxCharCount * 2;
    ZeroMemory(@sValue[0], SizeOf(sValue));
    ReadProcessMemory(hProcess, ptr(addr), @sValue[0], Size, BytesCountOfRead);
    Result := Copy(WideCharToString(sValue), 1, MaxCharCount);
  except
    result := '';
  end;
end;

function ReadInt32(addr: DWORD): DWORD;
var
  BytesCountOfRead: DWORD;
  Value: DWORD;
begin
  if (addr+4 < $FFFFFFFF) then
  try
    ReadProcessMemory(hProcess, ptr(addr), @Value, 4, BytesCountOfRead);
    Result := Value;
  except
    Result := 0;
  end
  else
    Result := 0;
end;

procedure WriteInt32(addr: DWORD; Value: DWORD);
var
  BytesCountOfWrite: DWORD;
begin
  if (addr+4 < $FFFFFFFF) then
  try
    WriteProcessMemory(hProcess, ptr(addr), @Value, 4, BytesCountOfWrite);
  except
  end;
end;

function dwValueToString(Value: DWORD): String;
begin
  result := IntToHex(Value, 8);
  result := result[7]+result[8]+' '+result[5]+result[6]+' '+
            result[3]+result[4]+' '+result[1]+result[2];
end;

type
  PWalkParams = ^TWalkParams;
  TWalkParams = packed record
    Packet: array [0..100] of byte;
    BaseAddr, GameAddr, CallAddress1,CallAddress2,CallAddress3: Pointer;
    x,y,z:  single;
    flying: DWORD;
    Param4: array [1..88] of widechar;
  end;

procedure WalkCall(aPParams: PWalkParams); Stdcall;
var
  GameAddr, CallAddress1,CallAddress2,CallAddress3:Pointer;
  x,y,z:single;
  flying:DWORD;
begin
 GameAddr := aPParams.GameAddr;
 CallAddress1:=aPParams.CallAddress1;
 CallAddress2:=aPParams.CallAddress2;
 CallAddress3:=aPParams.CallAddress3;
 x:=aPParams.x;
 y:=aPParams.y;
 z:=aPParams.z;
 flying:=aPParams.flying; // aPParams^.Param1;
 asm
  pushad
  mov eax, GameAddr
  mov eax, dword ptr [eax]
  mov esi, dword ptr [eax+$34]
  mov ecx, dword ptr [esi+$1050]
  push 1
  call CallAddress1
  mov edi, eax
  lea eax, dword ptr [esp+$18]
  push eax
  push flying
  mov ecx, edi
  call CallAddress2
  mov ecx, dword ptr [esi+$1050]
  push 0
  push 1
  push edi
  push 1
  call CallAddress3
  mov eax, GameAddr
  mov eax, dword ptr [eax]
  mov eax, dword ptr [eax+$34]
  mov eax, dword ptr [eax+$1050]
  mov eax, dword ptr [eax+$30]
  mov ecx, dword ptr [eax+$4]
  mov eax, x
  mov dword ptr[ecx+$20], eax
  mov eax, z
  mov dword ptr[ecx+$24], eax
  mov eax, y
  mov dword ptr[ecx+$28], eax
  popad
 end;
end;

function Walk(base_addr, game_addr, WalkMode, walkx_inject_addr, walky_inject_addr, walkz_inject_addr: dword;
  x,y,z: single): Boolean;
var
  aParams: TWalkParams;
begin
  if WalkMode = 0 then
    aParams.flying:=0
  else
    aParams.flying:=1;
  aParams.BaseAddr := Pointer(base_addr);
  aParams.GameAddr := Pointer(game_addr);
  aParams.CallAddress1 := Pointer(walkX_inject_addr);
  aParams.CallAddress2 := Pointer(walkY_inject_addr);
  aParams.CallAddress3 := Pointer(walkZ_inject_addr);
  aParams.x:=x;
  aParams.y:=y;
  aParams.z:=z;
  Result := (aParams.CallAddress1 <> nil) and (aParams.CallAddress2 <> nil) and (aParams.CallAddress3 <> nil) and
            (aParams.BaseAddr <> nil) and (aParams.GameAddr <> nil);
  if Result then
    InjectFunc(hProcess, @WalkCall, @aParams, SizeOf(aParams));
end;

end.
