unit fMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, IniFiles, ExtCtrls, Mask, ComCtrls, Spin, DB,
  DBGrids, DBClient, CheckLst;

const
  GamerOffsetsCount = 23;


  GamerWID = 0;
  GamerName = 1;
  GamerHP = 2;
  GamerMaxHP = 3;
  GamerMP = 4;
  GamerMaxMP = 5;
  GamerChi = 6;
  GamerTargetID = 7;
  GamerMeditation = 8;
  GamerLocX = 9;
  GamerLocY = 10;
  GamerLocZ = 11;
  GamerTargetX1 = 12;
  GamerTargetX2 = 13;
  GamerTargetY1 = 14;
  GamerTargetY2 = 15;
  GamerTargetZ1 = 16;
  GamerTargetZ2 = 17;
  GamerWalkMode = 18;
  GamerCast=19;

  PetNum = 20;
  PetHP = 21;
  PetHungry = 22;


  ControlPetHungry = 85;
  ControlPetHP = 90;

type
  TCoord = record
    X: Single;
    Y: Single;
    Z: Single;
  end;

  TGamerInfo = record
    WID: DWORD;
    Name: array[0..10] of WideChar;
    HP: DWORD;
    MaxHP: DWORD;
    MP: DWORD;
    MaxMP: DWORD;
    Chi: DWORD;
    Cast: DWORD;
    TargetID: DWORD;
    Meditation: BYTE;
    WalkMode: BYTE;
    PetNum: DWORD;
    PetHP: SINGLE;
    PetHungry: DWORD;
    Loc: TCoord;
    TargetPos: TCoord;
  end;

  TfrmMain = class(TForm)
    Label1: TLabel;
    obConnectToClient: TButton;
    lbConnectStatus: TLabel;
    Timer: TTimer;
    eClientCaption: TComboBox;
    cbAlwaysTop: TCheckBox;
    cbRename: TCheckBox;
    cbAutoTarget: TCheckBox;
    cbLut: TComboBox;
    Label6: TLabel;
    cbHP1: TComboBox;
    cbHPpercent1: TComboBox;
    Label7: TLabel;
    cbMPpercent: TComboBox;
    cbMP: TComboBox;
    cbPickUpLut: TCheckBox;
    GroupBox1: TGroupBox;
    cbAtaka1: TComboBox;
    cbAtaka5: TComboBox;
    cbAtaka4: TComboBox;
    cbAtaka3: TComboBox;
    cbAtaka2: TComboBox;
    GroupBox2: TGroupBox;
    Label8: TLabel;
    Label9: TLabel;
    cbBaff1: TComboBox;
    eBaff1: TEdit;
    Label4: TLabel;
    eBaff2: TEdit;
    Label5: TLabel;
    cbBaff2: TComboBox;
    Label10: TLabel;
    eBaff3: TEdit;
    Label11: TLabel;
    cbBaff3: TComboBox;
    Label12: TLabel;
    cbChiPercent: TComboBox;
    cbChi: TComboBox;
    Label13: TLabel;
    eAtaka1: TEdit;
    Label14: TLabel;
    Label15: TLabel;
    eAtaka2: TEdit;
    Label16: TLabel;
    Label17: TLabel;
    eAtaka3: TEdit;
    Label18: TLabel;
    Label19: TLabel;
    eAtaka4: TEdit;
    Label20: TLabel;
    Label21: TLabel;
    eAtaka5: TEdit;
    Label22: TLabel;
    GroupBox3: TGroupBox;
    Label3: TLabel;
    cbKorm: TComboBox;
    cbHill: TComboBox;
    Label2: TLabel;
    cbPetNoGrnd: TComboBox;
    eAtakTime: TEdit;
    Panel1: TPanel;
    cbPet: TCheckBox;
    Label23: TLabel;
    cbAttak: TCheckBox;
    Label24: TLabel;
    eHPtime1: TEdit;
    Label25: TLabel;
    eMPtime: TEdit;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    cbHP2: TComboBox;
    cbHPpercent2: TComboBox;
    Label29: TLabel;
    eHPtime2: TEdit;
    Label30: TLabel;
    Label31: TLabel;
    cbHP3: TComboBox;
    cbHPpercent3: TComboBox;
    Label32: TLabel;
    eHPtime3: TEdit;
    Label33: TLabel;
    eLutTime: TEdit;
    Label34: TLabel;
    cbRadius: TCheckBox;
    eRadius: TEdit;
    lbCenterCoord: TLabel;
    lbCoord: TLabel;
    cbRespTown: TCheckBox;
    cbRespPrist: TCheckBox;
    cbRespSvitok: TCheckBox;
    cbPetNoWater: TComboBox;
    cbPetNoAir: TComboBox;
    Label35: TLabel;
    Label36: TLabel;
    Label37: TLabel;
    lbPetNo: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure obConnectToClientClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure cbAlwaysTopClick(Sender: TObject);
    procedure cbRenameClick(Sender: TObject);
    procedure cbRadiusClick(Sender: TObject);
  private
    InTimer: Boolean;
    procedure SendKey(key: Word; const shift: TShiftState);
    { Private declarations }
  public
    base_addr: DWORD;
    packet_addr: DWORD;
    game_addr: DWORD;
    gamer_addr: DWORD;
    pet_addr: DWORD;
    Unfreeze_addr: DWORD;

    game_addr_offset: DWORD;
    gamer_addr_offset: DWORD;
    pet_addr_offset: DWORD;
    walkx_inject_addr: dword;
    walky_inject_addr: dword;
    walkz_inject_addr: dword;
    GamerOffsets: array[0..GamerOffsetsCount - 1] of DWORD;

    GamerInfo: TGamerInfo;
    PetAttak: Boolean;
    GamerWalked: Boolean;

    hW: THandle;
    pidw, pid: DWORD;

    unfreeze_flag: Byte;
    Lut: Boolean;
    PickUpLut: Boolean;
    AttakNo: Integer;
    Target: TCoord;
    WalkPos: TCoord;
    WalkMode: BYTE;
    Pos: TCoord;
    Center: TCoord;

    AttakTime: Cardinal;
    AttakTime1: Cardinal;
    AttakTime2: Cardinal;
    AttakTime3: Cardinal;
    AttakTime4: Cardinal;
    AttakTime5: Cardinal;
    BaffTime1: Cardinal;
    BaffTime2: Cardinal;
    BaffTime3: Cardinal;
    HPTime1: Cardinal;
    HPTime2: Cardinal;
    HPTime3: Cardinal;
    MPTime: Cardinal;
    WalkLutTime: Cardinal;
    PickUpLutTime: Cardinal;
    PetHungryTime: Cardinal;
    PetCallTime: Cardinal;

    function ConnectToClient: boolean;
    function ConnectedToClient: boolean;
    procedure DisconnectFromClient;
    procedure GetGamerInfo;
    function GetPetHP(PetNo: dword): DWORD;
    procedure unfreeze;
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses StrUtils, uMemory;

{$R *.dfm}

function FileVersion(AFileName: string): string;
var
  szName: array[0..255] of Char;
  P: Pointer;
  Value: Pointer;
  Len: UINT;
  GetTranslationString: string;
  FFileName: PChar;
  FValid: boolean;
  FSize: DWORD;
  FHandle: DWORD;
  FBuffer: PChar;
begin
  try
    FFileName := StrPCopy(StrAlloc(Length(AFileName) + 1), AFileName);
    FValid := False;
    FSize := GetFileVersionInfoSize(FFileName, FHandle);
    if FSize > 0 then
    try
      GetMem(FBuffer, FSize);
      FValid := GetFileVersionInfo(FFileName, FHandle, FSize, FBuffer);
    except
      FValid := False;
      raise;
    end;
    Result := '';
    if FValid then
      VerQueryValue(FBuffer, '\VarFileInfo\Translation', p, Len)
    else
      p := nil;
    if P <> nil then
      GetTranslationString := IntToHex(MakeLong(HiWord(Longint(P^)),
        LoWord(Longint(P^))), 8);
    if FValid then
    begin
      StrPCopy(szName, '\StringFileInfo\' + GetTranslationString +
        '\FileVersion');
      if VerQueryValue(FBuffer, szName, Value, Len) then
        Result := StrPas(PChar(Value));
    end;
  finally
    try
      if FBuffer <> nil then
        FreeMem(FBuffer, FSize);
    except
    end;
    try
      StrDispose(FFileName);
    except
    end;
  end;
end;

function iStrToNum(Value: String): Longint;
var
  i: integer;
  sValue: string;
begin
  sValue := '';
  i:= 1;
  while (i <= length(Value)) and not CharInSet(Value[i], ['0'..'9']) do
    inc(i);
  while (i <= length(Value)) and CharInSet(Value[i], ['0'..'9']) do
  begin
    sValue := sValue + Value[i];
    inc(i);
  end;
  result := StrToIntDef(sValue, 0);
end;

function StrToCode(KeyStr: String): DWORD;
begin
  KeyStr := UpperCase(KeyStr);
  if KeyStr = '1' then
    result := ord('1')
  else
  if KeyStr = '2' then
    result := ord('2')
  else
  if KeyStr = '3' then
    result := ord('3')
  else
  if KeyStr = '4' then
    result := ord('4')
  else
  if KeyStr = '5' then
    result := ord('5')
  else
  if KeyStr = '6' then
    result := ord('6')
  else
  if KeyStr = '7' then
    result := ord('7')
  else
  if KeyStr = '8' then
    result := ord('8')
  else
  if KeyStr = '9' then
    result := ord('9')
  else
  if KeyStr = 'F1' then
    result := VK_F1
  else
  if KeyStr = 'F2' then
    result := VK_F2
  else
  if KeyStr = 'F3' then
    result := VK_F3
  else
  if KeyStr = 'F4' then
    result := VK_F4
  else
  if KeyStr = 'F5' then
    result := VK_F5
  else
  if KeyStr = 'F6' then
    result := VK_F6
  else
  if KeyStr = 'F7' then
    result := VK_F7
  else
  if KeyStr = 'F8' then
    result := VK_F8
  else
    result := 0;
end;

procedure TfrmMain.SendKey(key: Word; const shift: TShiftState);
Type
 TBuffers = Array [0..1] of TKeyboardState;
Var
 pKeyBuffers : ^TBuffers;
 lparam: dword;
Begin
 (* check if the target window exists *)
 If IsWindow(hW) Then Begin
   (* set local variables to default values *)
   pKeyBuffers := Nil;
   lparam := MakeLong(0, MapVirtualKey(key, 0));

   (* allocate space for the key state buffers *)
   New(pKeyBuffers);
   try
     (* Fill buffer 1 with current state so we can later restore it.
        Null out buffer 0 to get a "no key pressed" state. *)
     GetKeyboardState( pKeyBuffers^[1] );
     FillChar(pKeyBuffers^[0], Sizeof(TKeyboardState), 0);

     (* set the requested modifier keys to "down" state in the buffer *)
     If ssShift In shift Then
       pKeyBuffers^[0][VK_SHIFT] := $80;
     If ssAlt In shift Then Begin
       (* Alt needs special treatment since a bit in lparam needs also be set*)
       pKeyBuffers^[0][VK_MENU] := $80;
       lparam := lparam or $20000000;
     End;
     If ssCtrl In shift Then
       pKeyBuffers^[0][VK_CONTROL] := $80;
     If ssLeft In shift Then
       pKeyBuffers^[0][VK_LBUTTON] := $80;
     If ssRight In shift Then
       pKeyBuffers^[0][VK_RBUTTON] := $80;
     If ssMiddle In shift Then
       pKeyBuffers^[0][VK_MBUTTON] := $80;

     (* make out new key state array the active key state map *)
     SetKeyboardState( pKeyBuffers^[0] );

     (* post the key messages *)
     If ssAlt In Shift Then Begin
       SendMessage( hW, WM_SYSKEYDOWN, key, longint(lparam));
       SendMessage( hW, WM_SYSKEYUP, key, longint(lparam or $C0000000));
     End
     Else Begin
       SendMessage( hW, WM_KEYDOWN, key, longint(lparam));
       SendMessage( hW, WM_KEYUP, key, longint(lparam or $C0000000));
     End;
     (* process the messages *)
     Application.ProcessMessages;

     (* restore the old key state map *)
     SetKeyboardState( pKeyBuffers^[1] );
   finally
     (* free the memory for the key state buffers *)
     If pKeyBuffers <> Nil Then
       Dispose( pKeyBuffers );
   End; { If }
 End;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
var
  ini: TIniFile;

  function ReadAddr(Section, Ident: string; Default: DWORD): DWORD;
  begin
    Result := StrToInt64Def('$' + ini.ReadString(Section, Ident, IntToHex(Default, 8)), Default);
    //         
    ini.WriteString(Section, Ident, IntToHex(Result, 8));
  end;

begin
  Caption := Caption + ' ' + FileVersion(Application.ExeName);
  InTimer := False;

  unfreeze_flag := 1;

  ini := TIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));

  base_addr := ReadAddr('Base', 'base_addr', $00B27A04);
  packet_addr := ReadAddr('Base', 'packet_addr', $006737B0);
  walkx_inject_addr := ReadAddr('Base', 'walkx_inject_addr', $0046E410);
  walky_inject_addr := ReadAddr('Base', 'walky_inject_addr', $004728E0);
  walkz_inject_addr := ReadAddr('Base', 'walkz_inject_addr', $0046E880);
  game_addr_offset := ReadAddr('Base', 'game_addr_offset', $0000001C);
  gamer_addr_offset := ReadAddr('Base', 'gamer_addr_offset', $00000034);
  pet_addr_offset := ReadAddr('Base', 'pet_addr_offset', $00001068);
  unfreeze_addr := ReadAddr('Base', 'unfreeze_addr', $00B28534);


  GamerOffsets[GamerHP] := ReadAddr('Gamer', 'HP', $00000490);
  GamerOffsets[GamerWID] := ReadAddr('Gamer', 'WID', $047C);
  GamerOffsets[GamerMaxHP] := ReadAddr('Gamer', 'MaxHP', $000004D0);
  GamerOffsets[GamerMP] := ReadAddr('Gamer', 'MP', $00000494);
  GamerOffsets[GamerMaxMP] := ReadAddr('Gamer', 'MaxMP', $000004D4);
  GamerOffsets[GamerChi] := ReadAddr('Gamer', 'Chi', $04A4);
  GamerOffsets[GamerTargetID] := ReadAddr('Gamer', 'TargetID', $00000B68);
  GamerOffsets[GamerMeditation] := ReadAddr('Gamer', 'GamerMeditation', $00000668);
  GamerOffsets[GamerWalkMode] := ReadAddr('Gamer', 'WalkMode', $064C);
  GamerOffsets[GamerName] := ReadAddr('Gamer', 'GamerName', $00000638);
  GamerOffsets[GamerLocX] := ReadAddr('Gamer', 'LocX', $003C);
  GamerOffsets[GamerLocY] := ReadAddr('Gamer', 'LocY', $0044);
  GamerOffsets[GamerLocZ] := ReadAddr('Gamer', 'LocZ', $0040);
  GamerOffsets[GamerTargetX1] := ReadAddr('Gamer', 'TargetX1', $10E8);
  GamerOffsets[GamerTargetX2] := ReadAddr('Gamer', 'TargetX2', $188);
  GamerOffsets[GamerTargetY1] := ReadAddr('Gamer', 'TargetY1', $10E8);
  GamerOffsets[GamerTargetY2] := ReadAddr('Gamer', 'TargetY2', $190);
  GamerOffsets[GamerTargetZ1] := ReadAddr('Gamer', 'TargetZ1', $10E8);
  GamerOffsets[GamerTargetZ2] := ReadAddr('Gamer', 'TargetZ2', $18C);
  GamerOffsets[GamerCast] := ReadAddr('Gamer', 'Cast', $06F4);
  GamerOffsets[PetNum] := ReadAddr('Pet', 'PetNum', $8);
  GamerOffsets[PetHP] := ReadAddr('Pet', 'PetHP', $1C);
  GamerOffsets[PetHungry] := ReadAddr('Pet', 'PetHungry', $8);

  Ini.ReadSection('Perfect World Captions', eClientCaption.Items);

  cbAlwaysTop.Checked := ini.ReadBool('Common', 'AlwaysTop', True);
  cbRename.Checked := ini.ReadBool('Common', 'Rename', True);
  Width := ini.ReadInteger('Common', 'Width', Width);
  Height := ini.ReadInteger('Common', 'Height', Height);

  cbPet.Checked := ini.ReadBool('Keys', 'Pet', False);
  cbPetNoGrnd.ItemIndex := cbPetNoGrnd.Items.IndexOf(ini.ReadString('Keys', 'PetNoGrnd', '0'));
  cbPetNoWater.ItemIndex := cbPetNoWater.Items.IndexOf(ini.ReadString('Keys', 'PetNoWater', '0'));
  cbPetNoAir.ItemIndex := cbPetNoAir.Items.IndexOf(ini.ReadString('Keys', 'PetNoAir', '0'));

  cbHill.ItemIndex := cbHill.Items.IndexOf(ini.ReadString('Keys', 'Hill', '-'));
  cbKorm.ItemIndex := cbKorm.Items.IndexOf(ini.ReadString('Keys', 'Korm', '-'));
  eAtakTime.Text := ini.ReadString('Keys', 'AttakTime', '0');
  cbAtaka1.ItemIndex := cbAtaka1.Items.IndexOf(ini.ReadString('Keys', 'Ataka1', '-'));
  eAtaka1.Text := ini.ReadString('Keys', 'AttakTime1', '0');
  cbAtaka2.ItemIndex := cbAtaka2.Items.IndexOf(ini.ReadString('Keys', 'Ataka2', '-'));
  eAtaka2.Text := ini.ReadString('Keys', 'AttakTime2', '0');
  cbAtaka3.ItemIndex := cbAtaka3.Items.IndexOf(ini.ReadString('Keys', 'Ataka3', '-'));
  eAtaka3.Text := ini.ReadString('Keys', 'AttakTime3', '0');
  cbAtaka4.ItemIndex := cbAtaka4.Items.IndexOf(ini.ReadString('Keys', 'Ataka4', '-'));
  eAtaka4.Text := ini.ReadString('Keys', 'AttakTime4', '0');
  cbAtaka5.ItemIndex := cbAtaka5.Items.IndexOf(ini.ReadString('Keys', 'Ataka5', '-'));
  eAtaka5.Text := ini.ReadString('Keys', 'AttakTime5', '0');
  cbHP1.ItemIndex := cbHP1.Items.IndexOf(ini.ReadString('Keys', 'HP1', '-'));
  cbHPpercent1.ItemIndex := cbHPpercent1.Items.IndexOf(ini.ReadString('Keys', 'HPpercent1', '70%'));
  eHPtime1.Text := ini.ReadString('Keys', 'HPtime1', '16');
  cbHP2.ItemIndex := cbHP2.Items.IndexOf(ini.ReadString('Keys', 'HP2', '-'));
  cbHPpercent2.ItemIndex := cbHPpercent2.Items.IndexOf(ini.ReadString('Keys', 'HPpercent2', '50%'));
  eHPtime2.Text := ini.ReadString('Keys', 'HPtime2', '11');
  cbHP3.ItemIndex := cbHP3.Items.IndexOf(ini.ReadString('Keys', 'HP3', '-'));
  cbHPpercent3.ItemIndex := cbHPpercent3.Items.IndexOf(ini.ReadString('Keys', 'HPpercent3', '30%'));
  eHPtime3.Text := ini.ReadString('Keys', 'HPtime3', '61');
  cbMP.ItemIndex := cbMP.Items.IndexOf(ini.ReadString('Keys', 'MP', '-'));
  cbMPpercent.ItemIndex := cbMPpercent.Items.IndexOf(ini.ReadString('Keys', 'MPpercent', '70%'));
  eMPtime.Text := ini.ReadString('Keys', 'MPtime', '16');
  cbLut.ItemIndex := cbLut.Items.IndexOf(ini.ReadString('Keys', 'Lut', '-'));
  cbBaff1.ItemIndex := cbBaff1.Items.IndexOf(ini.ReadString('Keys', 'Baff1', '-'));
  eBaff1.Text := ini.ReadString('Keys', 'BaffTime1', '60');
  cbBaff2.ItemIndex := cbBaff2.Items.IndexOf(ini.ReadString('Keys', 'Baff2', '-'));
  eBaff2.Text := ini.ReadString('Keys', 'BaffTime2', '60');
  cbBaff3.ItemIndex := cbBaff3.Items.IndexOf(ini.ReadString('Keys', 'Baff3', '-'));
  eBaff3.Text := ini.ReadString('Keys', 'BaffTime3', '60');
  cbChi.ItemIndex := cbChi.Items.IndexOf(ini.ReadString('Keys', 'Chi', '-'));
  cbChiPercent.ItemIndex := cbChipercent.Items.IndexOf(ini.ReadString('Keys', 'ChiPercent', '300%'));
  eLutTime.Text := ini.ReadString('Keys', 'LutTime', eLutTime.Text);
  eRadius.Text := ini.ReadString('Keys', 'Radius', eRadius.Text);

  ini.Free;

  if cbAlwaysTop.Checked then
    FormStyle := fsStayOnTop
  else
    FormStyle := fsNormal;

  PetAttak := False;
  Lut := False;
  PickUpLut := False;
  AttakTime  := $FFFFFFFF;
  AttakTime1 := 0;
  AttakTime2 := 0;
  AttakTime3 := 0;
  AttakTime4 := 0;
  AttakTime5 := 0;
  BaffTime1 := 0;
  BaffTime2 := 0;
  BaffTime3 := 0;
  HPTime1 := 0;
  HPTime2 := 0;
  HPTime3 := 0;
  MPTime := 0;
  WalkLutTime := 0;
  PickUpLutTime := 0;
  PetHungryTime := 0;
  PetCallTime := 0;
  WalkMode := 0;
  AttakNo := 0;

  Target.X := 0;
  Target.Y := 0;
  Target.Z := 0;

  Pos.X := 0;
  Pos.Y := 0;
  Pos.Z := 0;
end;

procedure TfrmMain.FormDestroy(Sender: TObject);
var
  i: integer;
  Ini: TIniFile;
begin
  DisconnectFromClient;

  ini := TIniFile.Create(ChangeFileExt(Application.ExeName, '.ini'));

  try
    for I := 0 to eClientCaption.Items.Count - 1 do
      Ini.WriteString('Perfect World Captions', eClientCaption.Items[i], '');
  except
  end;

  ini.WriteBool('Common', 'AlwaysTop', cbAlwaysTop.Checked);
  ini.WriteBool('Common', 'Rename', cbRename.Checked);
  ini.WriteInteger('Common', 'Width', Width);
  ini.WriteInteger('Common', 'Height', Height);

  ini.WriteBool('Keys', 'Pet', cbPet.Checked);
  ini.WriteString('Keys', 'PetNoGrnd', cbPetNoGrnd.Text);
  ini.WriteString('Keys', 'PetNoWater', cbPetNoWater.Text);
  ini.WriteString('Keys', 'PetNoAir', cbPetNoAir.Text);

  ini.WriteString('Keys', 'AttakTime', eAtakTime.Text);
  ini.WriteString('Keys', 'Hill', cbHill.Text);
  ini.WriteString('Keys', 'Korm', cbKorm.Text);
  ini.WriteString('Keys', 'Ataka1', cbAtaka1.Text);
  ini.WriteString('Keys', 'AttakTime1', eAtaka1.Text);
  ini.WriteString('Keys', 'Ataka2', cbAtaka2.Text);
  ini.WriteString('Keys', 'AttakTime2', eAtaka2.Text);
  ini.WriteString('Keys', 'Ataka3', cbAtaka3.Text);
  ini.WriteString('Keys', 'AttakTime3', eAtaka3.Text);
  ini.WriteString('Keys', 'Ataka4', cbAtaka4.Text);
  ini.WriteString('Keys', 'AttakTime4', eAtaka4.Text);
  ini.WriteString('Keys', 'Ataka5', cbAtaka5.Text);
  ini.WriteString('Keys', 'AttakTime5', eAtaka5.Text);
  ini.WriteString('Keys', 'HP1', cbHP1.Text);
  ini.WriteString('Keys', 'HPpercent1', cbHPpercent1.Text);
  ini.WriteString('Keys', 'HPtime1', eHPtime1.Text);
  ini.WriteString('Keys', 'HP2', cbHP2.Text);
  ini.WriteString('Keys', 'HPpercent2', cbHPpercent2.Text);
  ini.WriteString('Keys', 'HPtime2', eHPtime2.Text);
  ini.WriteString('Keys', 'HP3', cbHP3.Text);
  ini.WriteString('Keys', 'HPpercent3', cbHPpercent3.Text);
  ini.WriteString('Keys', 'HPtime3', eHPtime3.Text);
  ini.WriteString('Keys', 'MP', cbMP.Text);
  ini.WriteString('Keys', 'MPpercent', cbMPpercent.Text);
  ini.WriteString('Keys', 'MPtime', eMPtime.Text);
  ini.WriteString('Keys', 'Lut', cbLut.Text);
  ini.WriteString('Keys', 'LutTime', eLutTime.Text);
  ini.WriteString('Keys', 'Radius', eRadius.Text);
  ini.WriteString('Keys', 'Baff1', cbBaff1.Text);
  ini.WriteString('Keys', 'BaffTime1', eBaff1.Text);
  ini.WriteString('Keys', 'Baff2', cbBaff2.Text);
  ini.WriteString('Keys', 'BaffTime2', eBaff2.Text);
  ini.WriteString('Keys', 'Baff3', cbBaff3.Text);
  ini.WriteString('Keys', 'BaffTime3', eBaff3.Text);
  ini.WriteString('Keys', 'Chi', cbChi.Text);
  ini.WriteString('Keys', 'ChiPercent', cbChipercent.Text);

  ini.Free;
end;

function TfrmMain.ConnectToClient: boolean;
var
  addr: DWORD;
  BytesCountOfRead: DWORD;
begin
  try
    DisconnectFromClient;
    hw := FindWindow(nil, pChar(eClientCaption.text));
    pidw := GetWindowThreadProcessId(hw, pid);
    hProcess := OpenProcess(PROCESS_ALL_ACCESS, False, pid);
    Result := hProcess <> 0;
    if result then
    begin
      ReadProcessMemory(hProcess, ptr(base_addr), @addr, sizeof(addr), BytesCountOfRead);
      game_addr := addr + game_addr_offset;
    end;
  except
    Result := False;
  end;
end;

procedure TfrmMain.DisconnectFromClient;
begin
  if ConnectedToClient then
    CloseHandle(hProcess);
  hProcess := 0;
end;

function TfrmMain.ConnectedToClient: boolean;
begin
  Result := hProcess <> 0;
end;

procedure TfrmMain.obConnectToClientClick(Sender: TObject);
begin
  //    
  if not Timer.Enabled then
  begin
    lbConnectStatus.Color := clRed;
    if ConnectToClient then
      lbConnectStatus.Caption := ' '
    else
      lbConnectStatus.Caption := ' ';
    lbConnectStatus.Update;
    Sleep(500);
    lbConnectStatus.Color := clBtnFace;
    lbConnectStatus.Update;
    if ConnectedToClient then
    begin
      if eClientCaption.Items.IndexOf(eClientCaption.Text) < 0 then
        eClientCaption.Items.Add(eClientCaption.Text);
      GetGamerInfo;
      if cbRename.Checked then
        cbRenameClick(cbRename);
      obConnectToClient.Caption := '';
      Timer.Enabled := True;
    end;
  end
  else
  begin
    Timer.Enabled := False;
    DisconnectFromClient;
    obConnectToClient.Caption := '';
  end;
end;

function TfrmMain.GetPetHP(PetNo: dword): DWORD;
var
  BytesCountOfRead: DWORD;
  addr, pet: DWORD;
  i: integer;
begin
  Result := 0;
  if ConnectedToClient then
  begin
    try
      ReadProcessMemory(hProcess, ptr(game_addr), @addr, sizeof(addr), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(addr + gamer_addr_offset), @gamer_addr, sizeof(gamer_addr), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + pet_addr_offset), @pet_addr, sizeof(pet_addr), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(pet_addr + PetNo * 4 + $10), @Pet, sizeof(Pet), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(pet + GamerOffsets[PetHP]), @Result, sizeof(Result), BytesCountOfRead);
    except
    end;
  end;
end;

procedure TfrmMain.GetGamerInfo;
var
  BytesCountOfRead: DWORD;
  addr, pet: DWORD;
  i: integer;
  ch: WideChar;
  st: string;
begin
  ZeroMemory(@GamerInfo, SizeOf(GamerInfo));
  if ConnectedToClient then
  begin
    try
      ReadProcessMemory(hProcess, ptr(game_addr), @addr, sizeof(addr), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(addr + gamer_addr_offset), @gamer_addr, sizeof(gamer_addr), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + pet_addr_offset), @pet_addr, sizeof(pet_addr), BytesCountOfRead);

      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerWID]), @GamerInfo.WID, sizeof(GamerInfo.WID), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerHP]), @GamerInfo.HP, sizeof(GamerInfo.HP), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerMaxHP]), @GamerInfo.MaxHP, sizeof(GamerInfo.MaxHP), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerMP]), @GamerInfo.MP, sizeof(GamerInfo.MP), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerMaxMP]), @GamerInfo.MaxMP, sizeof(GamerInfo.MaxMP), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerChi]), @GamerInfo.Chi, sizeof(GamerInfo.Chi), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerTargetID]), @GamerInfo.TargetID, sizeof(GamerInfo.TargetID), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerMeditation]), @GamerInfo.Meditation, sizeof(GamerInfo.Meditation), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerWalkMode]), @GamerInfo.WalkMode, sizeof(GamerInfo.WalkMode), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerCast]), @GamerInfo.Cast, sizeof(GamerInfo.Cast), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerLocX]), @GamerInfo.Loc.X, sizeof(GamerInfo.Loc.X), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerLocY]), @GamerInfo.Loc.Y, sizeof(GamerInfo.Loc.Y), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerLocZ]), @GamerInfo.Loc.Z, sizeof(GamerInfo.Loc.Z), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerTargetX1]), @addr, sizeof(addr), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(      addr + GamerOffsets[GamerTargetX2]), @GamerInfo.TargetPos.X, sizeof(GamerInfo.TargetPos.X), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerTargetY1]), @addr, sizeof(addr), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(      addr + GamerOffsets[GamerTargetY2]), @GamerInfo.TargetPos.Y, sizeof(GamerInfo.TargetPos.Y), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerTargetZ1]), @addr, sizeof(addr), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(      addr + GamerOffsets[GamerTargetZ2]), @GamerInfo.TargetPos.Z, sizeof(GamerInfo.TargetPos.Z), BytesCountOfRead);
      ReadProcessMemory(hProcess, ptr(pet_addr + GamerOffsets[PetNum]), @GamerInfo.PetNum, sizeof(GamerInfo.PetNum), BytesCountOfRead);
      if GamerInfo.PetNum <> $FFFFFFFF then
      begin
        ReadProcessMemory(hProcess, ptr(pet_addr + GamerInfo.PetNum * 4 + $10), @Pet, sizeof(Pet), BytesCountOfRead);
        ReadProcessMemory(hProcess, ptr(pet + GamerOffsets[PetHP]), @GamerInfo.PetHP, sizeof(GamerInfo.PetHP), BytesCountOfRead);
        ReadProcessMemory(hProcess, ptr(pet + GamerOffsets[PetHungry]), @GamerInfo.PetHungry, sizeof(GamerInfo.PetHungry), BytesCountOfRead);
      end
      else
      begin
        GamerInfo.PetHP := 100;
        GamerInfo.PetHungry := $FFFFFFFF;
      end;

    except
    end;

    GamerInfo.Name[0] := #0;
    i := 0;
    try
      ReadProcessMemory(hProcess, ptr(gamer_addr + GamerOffsets[GamerName]), @addr, sizeof(addr), BytesCountOfRead);
      repeat
        ReadProcessMemory(hProcess, ptr(addr), @ch, 2, BytesCountOfRead);
        GamerInfo.Name[i] := ch;
        addr := addr + 2;
        inc(i);
      until (ord(ch) = 0) or (i >= 10);
    except
    end;
    if i <= 1 then
    begin
      St := IntToStr(Random(MaxInt));
      StringToWideChar(St, GamerInfo.Name, 11);
    end
    else
      GamerInfo.Name[i] := #0;
  end;
end;

procedure TfrmMain.TimerTimer(Sender: TObject);
label
  lExit;
var
  i: integer;
  KeyCode: WORD;
  percent: integer;
  PetNo: Integer;
  PetHP: dword;
  t: Cardinal;
  atkTime: Cardinal;
  Radius: Integer;
begin
  if InTimer then
    Exit;
  InTimer := True;

  if ConnectedToClient then
  begin
    //   
    GetGamerInfo;

    lbCoord.Caption := 'X='+FloatToStr((4000+round(GamerInfo.Loc.X))/10)+'   '+
                       'Y='+FloatToStr((5500+round(GamerInfo.Loc.Y))/10)+'   '+
                       'Z='+FloatToStr(round(GamerInfo.Loc.Z)/10);
    if cbRadius.Checked then
      lbCenterCoord.Caption := 'X='+FloatToStr((4000+round(Center.X))/10)+'   '+
                               'Y='+FloatToStr((5500+round(Center.Y))/10)+'   '+
                               'Z='+FloatToStr(round(Center.Z)/10);

    if GamerInfo.PetNum = $FFFFFFFF then
      lbPetNo.Caption := '-'
    else
      lbPetNo.Caption := IntToStr(GamerInfo.PetNum);

    if GamerInfo.TargetID = GamerInfo.WID then
      goto lExit;

    if GamerInfo.HP = 0 then
    begin
      if cbRespPrist.Checked then
        Packet(base_addr, packet_addr, '57 00')
      else
      if cbRespSvitok.Checked then
        Packet(base_addr, packet_addr, '05 00')
      else
      if cbRespTown.Checked then
      begin
        Packet(base_addr, packet_addr, '04 00');
        cbRadius.Checked := False;
      end;
      Packet(base_addr, packet_addr, '02 00 '+dwValueToString(GamerInfo.WID));
      goto lExit;
    end;

    if (Target.X = 0) and (Target.Y = 0) and (Target.Z = 0) then
      Target := GamerInfo.Loc;

    if (Pos.X = 0) and (Pos.Y = 0) and (Pos.Z = 0) then
      Pos := GamerInfo.Loc;

    GamerWalked := (abs(GamerInfo.Loc.X - Pos.X) > 0.2) or
                   (abs(GamerInfo.Loc.Y - Pos.Y) > 0.2) or
                   (abs(GamerInfo.Loc.Z - Pos.Z) > 0.2);

    //   
    KeyCode := StrToCode(cbHP1.Text);
    if (KeyCode > 0) and (GamerInfo.MaxHP > 0) and (HPTime1 < GetTickCount) then
    begin
      percent := iStrToNum(cbHPpercent1.Text);
      if percent >=  (GamerInfo.HP*100/GamerInfo.MaxHP) then
      begin
        unfreeze;
        SendKey(KeyCode, []);
        HPTime1 := GetTickCount + iStrToNum(eHPtime1.Text) * 1000;
      end;
    end;

    KeyCode := StrToCode(cbHP2.Text);
    if (KeyCode > 0) and (GamerInfo.MaxHP > 0) and (HPTime2 < GetTickCount) then
    begin
      percent := iStrToNum(cbHPpercent2.Text);
      if percent >=  (GamerInfo.HP*100/GamerInfo.MaxHP) then
      begin
        unfreeze;
        SendKey(KeyCode, []);
        HPTime2 := GetTickCount + iStrToNum(eHPtime2.Text) * 1000;
      end;
    end;

    KeyCode := StrToCode(cbHP3.Text);
    if (KeyCode > 0) and (GamerInfo.MaxHP > 0) and (HPTime3 < GetTickCount) then
    begin
      percent := iStrToNum(cbHPpercent3.Text);
      if percent >=  (GamerInfo.HP*100/GamerInfo.MaxHP) then
      begin
        unfreeze;
        SendKey(KeyCode, []);
        HPTime3 := GetTickCount + iStrToNum(eHPtime3.Text) * 1000;
      end;
    end;

    //   
    KeyCode := StrToCode(cbMP.Text);
    if (KeyCode > 0) and (GamerInfo.MaxMP > 0) and (MPTime < GetTickCount) then
    begin
      percent := iStrToNum(cbMPpercent.Text);
      if percent >=  (GamerInfo.MP*100/GamerInfo.MaxMP) then
      begin
        unfreeze;
        SendKey(KeyCode, []);
        MPTime := GetTickCount + iStrToNum(eMPtime.Text) * 1000;
      end;
    end;

    //  
    if (GamerInfo.PetNum = $FFFFFFFF) and cbPet.Checked and
       (PetCallTime < GetTickCount) then
    begin
      case GamerInfo.WalkMode of
        1: if cbPetNoWater.ItemIndex > 0 then
             PetNo := iStrToNum(cbPetNoWater.Text) // 
           else
             PetNo := -1;
        2: if cbPetNoAir.ItemIndex > 0 then
             PetNo := iStrToNum(cbPetNoAir.Text) // 
           else
             PetNo := -1;
      else
           if cbPetNoGrnd.ItemIndex > 0 then
             PetNo := iStrToNum(cbPetNoGrnd.Text) // 
           else
             PetNo := -1;
      end;
      if PetNo >= 0 then
      begin
        PetHP := GetPetHP(PetNo);
        if PetHP > 0 then
        begin
          Packet(base_addr, packet_addr, '64 00 '+dwValueToString(PetNo)); //  
          PetCallTime := GetTickCount + 5 * 1000; //     
        end;
      end;
    end;

    //   
    if (GamerInfo.PetNum <> $FFFFFFFF) and ((100 - longint(GamerInfo.PetHungry) * 20) < ControlPetHungry) and
       (PetHungryTime < GetTickCount) then
    begin
      KeyCode := StrToCode(cbKorm.Text);
      if KeyCode > 0 then
      begin
        unfreeze;
        SendKey(KeyCode, []);
        PetHungryTime := GetTickcount + 60 * 1000; //     60 
      end;
    end;

    //  HP 
    if (GamerInfo.PetNum <> $FFFFFFFF) and ((GamerInfo.PetHP * 100) < ControlPetHP) then
    begin
      KeyCode := StrToCode(cbHill.Text);
      if KeyCode > 0 then
      begin
        unfreeze;
        SendKey(KeyCode, []);
      end;
    end;

    // 
    if (BaffTime1 < GetTickCount) and (GamerInfo.Cast = 0)  then
    begin
      KeyCode := StrToCode(cbBaff1.Text);
      if KeyCode > 0 then
      begin
        unfreeze;
        SendKey(KeyCode, []);
        BaffTime1 := GetTickCount + StrToIntDef(eBaff1.Text, 60)*1000;
      end;
    end;

    if (BaffTime2 < GetTickCount) and (GamerInfo.Cast = 0) then
    begin
      KeyCode := StrToCode(cbBaff2.Text);
      if KeyCode > 0 then
      begin
        unfreeze;
        SendKey(KeyCode, []);
        BaffTime2 := GetTickCount + StrToIntDef(eBaff2.Text, 60)*1000;
      end;
    end;

    if (BaffTime3 < GetTickCount) and (GamerInfo.Cast = 0) then
    begin
      KeyCode := StrToCode(cbBaff3.Text);
      if KeyCode > 0 then
      begin
        unfreeze;
        SendKey(KeyCode, []);
        BaffTime3 := GetTickCount + StrToIntDef(eBaff3.Text, 60)*1000;
      end;
    end;

    //  
    KeyCode := StrToCode(cbLut.Text);
    if (GamerInfo.TargetID = 0) and (KeyCode > 0) and cbPickUpLut.Checked then
    begin
      if not Lut then
      begin
        WalkLutTime := GetTickCount + 20*1000; // 20    
        Lut := True;
      end;
      if ((abs(GamerInfo.Loc.X - Target.X) > 0.5) or
          (abs(GamerInfo.Loc.Y - Target.Y) > 0.5) {or
          (abs(GamerInfo.Loc.Z - Target.Z) > 0.5)}) and not PickUpLut then
      begin
        WalkPos := Target;
        WalkMode := GamerInfo.WalkMode;
        Walk(base_addr, game_addr, WalkMode, walkx_inject_addr, walky_inject_addr, walkz_inject_addr, Target.X, Target.Y, Target.Z);
        GamerWalked := True;
      end
      else
      if not GamerWalked then
      begin
        if not PickUpLut then
          PickUpLutTime := GetTickCount + StrToIntDef(eLutTime.Text, 3)*1000; //    
        PickUpLut := True;
        unfreeze;
        SendKey(KeyCode, []);
        if (PickUpLutTime < GetTickCount) then
          Lut := False;
      end;
    end;

    if Lut and (WalkLutTime < GetTickCount) then
      Lut := False;

    //     
    Radius := iStrToNum(eRadius.Text)*10;
    if cbRadius.Checked and not Lut and  (GamerInfo.TargetID = 0) and
       ((abs(GamerInfo.Loc.X - Center.X) > Radius) or
        (abs(GamerInfo.Loc.Y - Center.Y) > Radius) or
        (abs(GamerInfo.Loc.Z - Center.Z) > Radius)) then
    begin
      WalkPos := Target;
      WalkMode := GamerInfo.WalkMode;
      Walk(base_addr, game_addr, WalkMode, walkx_inject_addr, walky_inject_addr, walkz_inject_addr, Center.X, Center.Y, Center.Z);
      GamerWalked := True;
    end;

    // 
    if cbAutoTarget.Checked and ((GamerInfo.TargetID = 0) or (AttakTime < GetTickCount)) and not Lut and not GamerWalked then
    begin
      KeyCode := VK_TAB;
      unfreeze;
      SendKey(KeyCode, []);
      PetAttak := False;
      t := iStrToNum(eAtakTime.Text) * 1000;
      if t = 0 then
        AttakTime := $FFFFFFFF
      else
        AttakTime := GetTickCount + t;

      Sleep(500);
      GetGamerInfo;
      if GamerInfo.TargetID = 0 then
      begin
        WalkPos := Target;
        WalkMode := GamerInfo.WalkMode;
        Walk(base_addr, game_addr, WalkMode, walkx_inject_addr, walky_inject_addr, walkz_inject_addr, Center.X, Center.Y, Center.Z);
        GamerWalked := True;
      end;
    end;

    //  
    KeyCode := StrToCode(cbChi.Text);
    percent := iStrToNum(cbChiPercent.Text);
    if (KeyCode > 0) and (GamerInfo.Chi > percent) then
    begin
      unfreeze;
      SendKey(KeyCode, []);
    end;

    // 
    if (GamerInfo.TargetID <> 0) and cbAttak.Checked and (GamerInfo.Cast = 0) then
    begin
      Target := GamerInfo.TargetPos;
      PickUpLut := False;
      if (GamerInfo.PetNum <> $FFFFFFFF) and not PetAttak then
      begin
        Packet(base_addr, packet_addr, '67 00 '+dwValueToString(GamerInfo.TargetID)+' 01 00 00 00 00');
        PetAttak := True;
      end;
      case AttakNo of
        1: atkTime := AttakTime2;
        2: atkTime := AttakTime3;
        3: atkTime := AttakTime4;
        4: atkTime := AttakTime5;
      else
           atkTime := AttakTime1;
      end;
      case AttakNo of
        1: KeyCode := StrToCode(cbAtaka2.Text);
        2: KeyCode := StrToCode(cbAtaka3.Text);
        3: KeyCode := StrToCode(cbAtaka4.Text);
        4: KeyCode := StrToCode(cbAtaka5.Text);
      else
        KeyCode := StrToCode(cbAtaka1.Text);
      end;
      if (KeyCode > 0) and (atkTime < GetTickCount) and
         ((GamerInfo.MaxMP = 0) or ((GamerInfo.MaxMP > 0) and ((GamerInfo.MP*100/GamerInfo.MaxMP) > 10))) then
      begin
        unfreeze;
        SendKey(KeyCode, []);
        case AttakNo of
          1: AttakTime2 := GetTickCount + StrToIntDef(eAtaka2.Text, 0)*1000;
          2: AttakTime3 := GetTickCount + StrToIntDef(eAtaka3.Text, 0)*1000;
          3: AttakTime4 := GetTickCount + StrToIntDef(eAtaka4.Text, 0)*1000;
          4: AttakTime5 := GetTickCount + StrToIntDef(eAtaka5.Text, 0)*1000;
        else
          AttakTime1 := GetTickCount + StrToIntDef(eAtaka1.Text, 0)*1000;
        end;
      end;
      AttakNo := (AttakNo + 1) mod 5;
    end;

    Pos := GamerInfo.Loc;
  end;
lExit:
  InTimer := False;
end;

procedure TfrmMain.cbAlwaysTopClick(Sender: TObject);
begin
  if cbAlwaysTop.Checked then
    FormStyle := fsStayOnTop
  else
    FormStyle := fsNormal;
end;

procedure TfrmMain.cbRadiusClick(Sender: TObject);
begin
  Center := GamerInfo.Loc;
end;

procedure TfrmMain.cbRenameClick(Sender: TObject);
var
  St: string;
begin
  if cbRename.Checked and ConnectedToClient then
  begin
    St := WideCharToString(GamerInfo.Name);
    SetWindowText(hW, PChar(St));
    eClientCaption.Text := St;
    if eClientCaption.Items.IndexOf(eClientCaption.Text) < 0 then
      eClientCaption.Items.Add(eClientCaption.Text);
  end;
end;

procedure TfrmMain.unfreeze;
var
  BytesCountOfWrite: DWORD;
begin
  unfreeze_flag := 1;
  WriteProcessMemory(hProcess, ptr(unfreeze_addr), @unfreeze_flag, 1, BytesCountOfWrite); // unfreeze
  //  SetForegroundWindow(hw);
end;

end.

